// KUAJIE Font Scanner Pro - popup.js v1.0.3
async function runSpeedTest() {
  const gStatus = document.getElementById('lat-google');
  const mStatus = document.getElementById('lat-mirror');
  const test = async (url) => {
    const ctrl = new AbortController();
    const timeout = setTimeout(() => ctrl.abort(), 3000);
    const start = Date.now();
    try {
      await fetch(url, { mode: 'no-cors', cache: 'no-store', signal: ctrl.signal });
      clearTimeout(timeout);
      return Date.now() - start;
    } catch (e) { return -1; }
  };
  const gLat = await test('https://fonts.googleapis.com/css?family=Inter');
  const mLat = await test('https://fonts.loli.net/css?family=Inter');
  gStatus.innerHTML = gLat > 0 ? `${gLat}ms` : '<span style="color:#e74c3c">超时</span>';
  mStatus.innerHTML = mLat > 0 ? `${mLat}ms` : '<span style="color:#e74c3c">失败</span>';
}

async function runAudit() {
  const scannerUI = document.getElementById('scanner-ui');
  const resultsUI = document.getElementById('results-ui');
  const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });

  if (!tab || !tab.url || tab.url.startsWith('chrome') || tab.url.startsWith('about')) {
    scannerUI.innerHTML = '<div class="scanning-text">⚠️ 请在普通网页运行</div>';
    return;
  }

  chrome.scripting.executeScript({
    target: { tabId: tab.id },
    func: () => {
      const res = performance.getEntriesByType('resource');
      const fonts = res.filter(r => r.name.includes('googleapis.com') || r.name.includes('gstatic.com'));
      return {
        count: fonts.length,
        size: (fonts.reduce((a, b) => a + (b.transferSize || 0), 0) / 1024).toFixed(1),
        time: fonts.length > 0 ? Math.max(...fonts.map(f => f.duration)).toFixed(0) : 0,
        list: fonts.map(f => f.name)
      };
    }
  }, (results) => {
    setTimeout(() => {
      if (chrome.runtime.lastError || !results || !results[0]) {
        scannerUI.innerHTML = '<div class="scanning-text">❌ 扫描失败</div>';
        return;
      }
      const data = results[0].result;
      scannerUI.style.display = 'none';
      resultsUI.style.display = 'block';
      document.getElementById('stat-count').textContent = data.count;
      document.getElementById('stat-size').textContent = data.size + ' KB';
      document.getElementById('stat-time').textContent = data.time + ' ms';
      const list = document.getElementById('leak-details');
      data.list.forEach(url => {
        const li = document.createElement('li');
        li.className = 'leak-item';
        li.textContent = url.split('?')[0].substring(0, 50) + '...';
        list.appendChild(li);
      });
    }, 1200);
  });
}

document.addEventListener('DOMContentLoaded', () => {
  runSpeedTest();
  runAudit();
});
